/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.generic;

import ibm.nways.generic.eui.ConfigurationGroup;
import ibm.nways.generic.eui.FaultGroup;
import ibm.nways.jdm.GraphicComponent;
import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicHelp;
import ibm.nways.jdm.GraphicImage;
import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.HelpRef;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.MessageDestination;
import ibm.nways.jdm.NavigationBrowser;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.NavigationDestination;
import ibm.nways.jdm.NavigationFolder;
import ibm.nways.jdm.NavigationItem;
import ibm.nways.jdm.NavigationPoint;
import ibm.nways.jdm.browser.Browser;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.NotSupported;
import ibm.nways.jdm.common.Timeout;
import ibm.nways.jdm.eui.BoxDownMsg;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm.modelgen.SnmpContextModel;
import ibm.nways.mib2.eui.SystemGroup;
import ibm.nways.telnet.TelnetContext;
import java.awt.Image;
import java.awt.Point;
import java.io.Serializable;
import java.util.ResourceBundle;

public class GenericJdm
extends JdmBrowser {
    NavigationFolder root;
    GenModel model;
    private ResourceBundle genericBundle;
    private NavigationBrowser tree;
    private boolean deviceIsUp;
    private SnmpContextModel contextModel;

    public String getModelTypeName() {
        return "ibm.nways.generic.model.Generic";
    }

    protected synchronized SnmpContextModel getContextModel() {
        SnmpContextModel snmpContextModel = null;
        GenericJdm genericJdm = this;
        synchronized (genericJdm) {
            if (this.contextModel == null) {
                try {
                    this.contextModel = (SnmpContextModel)this.model.getComponent("_ContextInfo");
                }
                catch (Exception exception) {
                    this.contextModel = null;
                    exception.printStackTrace();
                }
            }
            snmpContextModel = this.contextModel;
        }
        return snmpContextModel;
    }

    public GraphicPanel getDeviceGraphicPanel() {
        GraphicPanel graphicPanel = null;
        try {
            Object object;
            this.displayMsg(this.genericBundle.getString("startGraphic"));
            SnmpContextModel snmpContextModel = this.getContextModel();
            String string = snmpContextModel.getSystemIdentifier();
            GraphicContainer graphicContainer = new GraphicContainer();
            if (string != null) {
                object = this.imageFrom(this, string);
                GraphicImage graphicImage = new GraphicImage((Image)object, new Point(19, 0), 1);
                graphicContainer.add(graphicImage);
            }
            object = new GraphicHelp(this, new Point(0, 5), new HelpRef(this));
            graphicContainer.add((GraphicComponent)object);
            graphicPanel = new GraphicPanel(this, graphicContainer);
            this.displayMsg(this.genericBundle.getString("endGraphic"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return graphicPanel;
    }

    private void getInitialDeviceInfo() {
        try {
            ModelInfo modelInfo = this.model.getInfo("Config");
            Serializable serializable = modelInfo.get("Config.SysUpTime");
            if (serializable instanceof Timeout || serializable instanceof NotSupported) {
                System.out.println("Can't talk to the Device " + serializable.toString());
                this.deviceIsUp = false;
                new BoxDownMsg(this.getFrame(), this.genericBundle.getString("genericJDM"));
                return;
            }
            this.deviceIsUp = true;
            return;
        }
        catch (Exception exception) {
            System.out.println("Exception getting Initial Model");
            this.deviceIsUp = false;
            exception.printStackTrace();
            return;
        }
    }

    protected NavigationPoint getNavTreeRoot() {
        this.genericBundle = ResourceBundle.getBundle("ibm.nways.generic.Resources");
        this.displayMsg(this.genericBundle.getString("askServer"));
        this.model = (GenModel)this.getModel();
        this.displayMsg(this.genericBundle.getString("serverDone"));
        this.getInitialDeviceInfo();
        this.displayMsg(this.genericBundle.getString("createNavigationTree"));
        this.root = new NavigationFolder(this.genericBundle.getString("generic"));
        return this.root;
    }

    protected void getRestOfNavTree() {
        this.tree = this.getNavigationBrowser();
        NavigationContext navigationContext = this.root.getNavContext();
        navigationContext.put("TREE", this.tree);
        if (this.deviceIsUp) {
            try {
                GenModel genModel = (GenModel)this.model.getComponent("Configuration");
                ConfigurationGroup configurationGroup = new ConfigurationGroup(this, genModel);
                configurationGroup.setIsInitiallyExpanded(false);
                this.tree.addEventListener(configurationGroup);
                this.root.add(configurationGroup);
                NavigationFolder navigationFolder = new NavigationFolder(this.genericBundle.getString("system"), new NavigationDestination("ibm.nways.jdm.NilDestination", null));
                configurationGroup.add(navigationFolder);
                this.buildGeneral(navigationFolder);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.buildFault(this.root);
        } else {
            NavigationFolder navigationFolder = new NavigationFolder(this.genericBundle.getString("configuration"));
            this.root.add(navigationFolder);
            NavigationFolder navigationFolder2 = new NavigationFolder(this.genericBundle.getString("system"), new NavigationDestination("ibm.nways.jdm.NilDestination", null));
            navigationFolder.add(navigationFolder2);
            NavigationFolder navigationFolder3 = new NavigationFolder(this.genericBundle.getString("general"), new NavigationDestination("ibm.nways.jdm.NilDestination", null));
            navigationFolder2.add(navigationFolder3);
            SnmpContextModel snmpContextModel = this.getContextModel();
            navigationFolder3.add(new NavigationItem(this.genericBundle.getString("snmpConfig"), new NavigationDestination("ibm.nways.jdm.modelgen.SnmpConfigPanel", snmpContextModel), "SnmpConfig"));
            navigationFolder3.add(new NavigationItem(this.genericBundle.getString("perfConfig"), new NavigationDestination("ibm.nways.analysis.dpManager.Admin.DpAdminDestinationPanel", snmpContextModel), "PerfConfig"));
            NavigationItem navigationItem = new NavigationItem(this.genericBundle.getString("communications"), new MessageDestination(this.genericBundle.getString("notConfigured")));
            navigationFolder.add(navigationItem);
            this.root.add(new NavigationItem(this.genericBundle.getString("fault"), new MessageDestination(this.genericBundle.getString("notConfigured"))));
        }
        this.buildTools(this.root);
        this.displayMsg(this.genericBundle.getString("initDone"));
    }

    private void buildGeneral(NavigationFolder navigationFolder) {
        try {
            GenModel genModel = (GenModel)this.model.getComponent("System");
            if (genModel != null) {
                SystemGroup systemGroup = new SystemGroup(this, genModel);
                systemGroup.setIsInitiallyExpanded(false);
                this.tree.addEventListener(systemGroup);
                navigationFolder.add(systemGroup);
                SnmpContextModel snmpContextModel = this.getContextModel();
                systemGroup.add(new NavigationItem(this.genericBundle.getString("snmpConfig"), new NavigationDestination("ibm.nways.jdm.modelgen.SnmpConfigPanel", snmpContextModel), "SnmpConfig"));
                systemGroup.add(new NavigationItem(this.genericBundle.getString("perfConfig"), new NavigationDestination("ibm.nways.analysis.dpManager.Admin.DpAdminDestinationPanel", snmpContextModel), "PerfConfig"));
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void buildFault(NavigationFolder navigationFolder) {
        try {
            GenModel genModel = (GenModel)this.model.getComponent("Traps");
            FaultGroup faultGroup = new FaultGroup(this, genModel);
            faultGroup.setIsInitiallyExpanded(false);
            this.tree.addEventListener(faultGroup);
            navigationFolder.add(faultGroup);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private void buildTools(NavigationFolder navigationFolder) {
        NavigationFolder navigationFolder2 = new NavigationFolder(this.genericBundle.getString("tools"), new NavigationDestination("ibm.nways.jdm.NilDestination", null));
        navigationFolder.add(navigationFolder2);
        try {
            SnmpContextModel snmpContextModel = this.getContextModel();
            ModelInfo modelInfo = snmpContextModel.getConfig();
            String string = modelInfo.get("Config.Address").toString();
            ResourceBundle resourceBundle = ResourceBundle.getBundle("ibm.nways.telnet.TelnetPanelResources");
            TelnetContext telnetContext = new TelnetContext(string);
            NavigationItem navigationItem = new NavigationItem(resourceBundle.getString("TelnetPanelTitle"), new NavigationDestination("ibm.nways.telnet.TelnetPanel", null), "Telnet");
            NavigationContext navigationContext = navigationItem.getNavContext();
            navigationContext.put("telnetContext", telnetContext);
            navigationFolder2.add(navigationItem);
            Browser browser = new Browser("MIB Browser", this, snmpContextModel);
            NavigationBrowser navigationBrowser = this.getNavigationBrowser();
            navigationBrowser.addEventListener(browser);
            navigationFolder2.add(browser.getRootFolder());
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }
}

